from odoo import models
from odoo.addons.account.models.chart_template import template


class AccountChartTemplate(models.AbstractModel):
    _inherit = 'account.chart.template'

    @template('ga')
    def _get_ga_template_data(self):
        return {
            'name': 'Syscohada for Gabon',
            'parent': 'syscohada',
            'code_digits': '6',
        }

    @template('ga', 'res.company')
    def _get_ga_res_company(self):
        company_values = super()._get_syscohada_res_company()
        company_values[self.env.company.id].update(
            {
                'account_fiscal_country_id': 'base.ga',
                'account_sale_tax_id': 'tva_sale_19',
                'account_purchase_tax_id': 'tva_purchase_19',
            }
        )
        return company_values

    @template('ga', 'account.account')
    def _get_ga_account_account(self):
        return self._parse_csv('ga', 'account.account', module='l10n_syscohada')
