# -*- coding: utf-8 -*-

from odoo import models, fields, api


class demo(models.Model):
    _name = 'demo.demo'
    _description = 'demo.demo'

    part_name = fields.Char(string="备件名称", required=True)
    spare_part_storage_location = fields.Char(string="备件库位", required=True)
    spare_part_type = fields.Char(string="备件型号", required=True)
    spare_part_number = fields.Char(string="备件零件号", required=True)
    equipment = fields.Selection(
        selection=[
            ("robot A", "A"),
            ("robot B", "B"),
            ("general", "通用")
        ],
        string="所属设备",
        required=True,
    )
    spare_part_spices = fields.Selection(
        selection=[
            ("mechanical", "机械"),
            ("electrical", "电气"),
            ("general", "通用")
        ],
        string="备件类型",
        required=True,
    )
    spare_part_item = fields.Selection(
        selection=[
            ("material", "维修材料"),
            ("tool", "工具"),
            ("maintenance", "维修费用")
        ],
        string="备件种类",
        required=True,
    )
    spare_part_level = fields.Selection(
        selection=[
            ("A", "A"),
            ("B", "B"),
            ("S", "S")
        ],
        string="备件等级",
        required=True,
    )
    highest_inventory = fields.Integer(string="最高库存")
    lowest_inventory = fields.Integer(string="最低库存")
    description = fields.Text(string="备件备注")
    spare_part_brand = fields.Char(string="备件品牌")
    safety_inventory = fields.Integer(string="安全库存")
    current_inventory = fields.Integer(string="现有库存")
    product_line = fields.Selection(
        selection=[
            ("C100", "C100"),
            ("B_main", "B_main"),
            ("330B", "330B")
        ],
        string="关联产线",
        required=True, )

    related_device = fields.Char(string="关联设备")
    built_time = fields.Date(string="建账时间")
    out_time = fields.Date(string="出库时间")
    count_of_in_storage = fields.Date(string="入库数量")
    count_of_out_storage = fields.Date(string="出库数量")
    first_in_time = fields.Date(string="建账时间")
    purchase_engineer = fields.Char(string="采购人员")
    recipient = fields.Char(string="领用人员")
    management_department = fields.Char(string="管理部门")
    duty_engineer = fields.Char(string="负责人", required=True)
    department_manager = fields.Char(string="部门经理")


@api.depends('value')
def _value_pc(self):
    for record in self:
        record.value2 = float(record.value) / 100
